/*****************************************************************************
 *
 * File:  PV1_1.ddl
 * Version: 1.1.1
 * 
 *****************************************************************************
 * Copyright (c) 2007, HART Communication Foundation, All Rights Reserved
 *****************************************************************************
 *
 * Description: Defines the standard collections used by most DD's
 *
 *****************************************************************************
 */

/*****************************************************************************
 * The manufacturer line
 *****************************************************************************
 */
MANUFACTURER STANDARD, DEVICE_TYPE _PV, DEVICE_REVISION 1, DD_REVISION 1


/*****************************************************************************
 * Include Files
 *****************************************************************************
 */
#include "macros.h"
#include "methods.h"

/*****************************************************************************
 * Definitions (#define, typedef, enum)
 *****************************************************************************
 */

/*****************************************************************************
 * Analog channel variables and collection
 */

VARIABLE loopCurrent
{
    LABEL [loop_current];
    HELP [loop_current_help];
    CLASS ANALOG_CHANNEL & DYNAMIC;
    HANDLING READ;
    CONSTANT_UNIT [mA];
    TYPE FLOAT
    {
        DISPLAY_FORMAT ".3f";
        EDIT_FORMAT "8.3f";
    }
}

VARIABLE loop_alarm_code
{
    LABEL [alarm_select];
    HELP [alarm_code_help];
    CLASS ANALOG_CHANNEL;
    HANDLING READ;
    TYPE ENUMERATED
    {
        ALARM_SELECTION_CODE(0),
        ALARM_SELECTION_CODE(1),
        ALARM_SELECTION_CODE(239),
        ALARM_SELECTION_CODE(251)
    }
}

VARIABLE loop_flags
{
    LABEL [analog_channel_flags];
    HELP [analog_channel_flags_help];
    CLASS ANALOG_CHANNEL;
    HANDLING READ;
    TYPE BIT_ENUMERATED 
    {
        ANALOG_CHANNEL_FLAG(0x01)
    }
}

COLLECTION OF VARIABLE analog_io
{
    LABEL [analog_input];
    HELP [analog_input_block_help];
    MEMBERS
    {
        /* Analog Information */
        ANALOG_VALUE,           loopCurrent,        [loop_current],         [analog_value_help];
        ALARM_CODE,             loop_alarm_code,    [alarm_type],           [alarm_code_help];
        ANALOG_CHANNEL_FLAGS,   loop_flags,         [analog_channel_flags], [analog_channel_flags_help];
    }
}


/*****************************************************************************
 * Range/ scaling variables and collection
 */

VARIABLE percentRange                    
{
    LABEL [pv_percent_range];
    HELP [percent_of_range_help];
    CLASS RANGE & DYNAMIC;
    HANDLING READ;
    CONSTANT_UNIT [Percent];
    TYPE FLOAT
    {
        DISPLAY_FORMAT ".3f";
    }
}

VARIABLE transfer_function
{
    LABEL [transfer_function];
    HELP [transfer_function_help];
    CLASS RANGE;
    HANDLING READ;
    TYPE ENUMERATED
    {
        TRANSFER_FUNCTION_CODE (0),     /* Linear */
        TRANSFER_FUNCTION_CODE (1)      /* Square Root */
    }
}

VARIABLE upperRange_value
{
    LABEL [pv_urv];
    HELP [upper_range_value_help];
    CLASS RANGE;
    TYPE FLOAT
    {
        DISPLAY_FORMAT ".3f";
        EDIT_FORMAT "8.3f";
    }
}

VARIABLE lowerRange_value
{
    LABEL [pv_lrv];
    HELP [lower_range_value_help];
    CLASS RANGE;
    TYPE FLOAT
    {
        DISPLAY_FORMAT ".3f";
        EDIT_FORMAT "8.3f";
    }
}

/*
 * range units must be added to this collection.  range units are reqired by command 15
 */
COLLECTION OF VARIABLE scaling
{
    LABEL [analog_input];
    HELP [analog_input_block_help];
    MEMBERS
    {
        /* Range Information */
        PERCENT_RANGE,          percentRange,       [percent_of_range],     [percent_of_range_help];
        TRANSFER_FUNCTION,      transfer_function,  [transfer_function],    [transfer_function_help];
        UPPER_RANGE_VALUE,      upperRange_value,   [urv],                  [upper_range_value_help];
        LOWER_RANGE_VALUE,      lowerRange_value,   [lrv],                  [lower_range_value_help];
    }
}

/*****************************************************************************
 * Now to declare the dynamic variables, and the associated collections
 *
 * All primary_variable collections must contain the following members
 */
COLLECTION OF COLLECTION primary_variable
{
    MEMBERS
    {
        DEVICE_VARIABLE,        deviceVariables[0];
        RANGING,                scaling;
        DAQ,                    analog_io;
    }
}

COLLECTION OF COLLECTION secondary_variable
{
    MEMBERS
    {
        DEVICE_VARIABLE,        deviceVariables[1];
    }
}

COLLECTION OF COLLECTION tertiary_variable
{
    MEMBERS
    {
        DEVICE_VARIABLE,        deviceVariables[2];
    }
}

COLLECTION OF COLLECTION quaternary_variable
{
    MEMBERS
    {
        DEVICE_VARIABLE,        deviceVariables[3];
    }
}

/* This type of definition is needed in every device */
ARRAY OF COLLECTION dynamic_variables
{
    ELEMENTS
    {
        PRIMARY,        primary_variable,       [pv];
        SECONDARY,      secondary_variable,     [sv];
        TERTIARY,       tertiary_variable,      [tv];
        QUATERNARY,     quaternary_variable,    [qv];
    }
}

/*
 * Relationships
 */

UNIT scaling_units_relation
{
    deviceVariables[0].DIGITAL_UNITS:
        upperRange_value,
        lowerRange_value
}

WRITE_AS_ONE scaling_wao
{
    upperRange_value,
    lowerRange_value
}

